#include <stdio.h>
#include <stdlib.h>

#define DIM_MIN 1
#define DIM_MAX 9
#define F DIM_MAX
#define C F


int generar_quadrat_magic(int matriu[][C], int dim);
int validar_quadrat_magic(int matriu[][C], int dim);
int mostrar_matriu(int matriu[][C], int dim);


int main()
{
    int dim, quadrat_magic[F][C] = { 0 };
    
    do
    {
      printf("Fica la dimensio del quadrat magic (max. %d): ", DIM_MAX);
      scanf("%d", &dim);
      if (dim % 2 == 0) { printf("\tHas de ficar un nombre imparell!\n"); }
      if (dim > DIM_MAX) { printf("\tHas de ficar un nombre igual o inferior a %d!\n", DIM_MAX); }
      if (dim < 3) { printf("\tHas de ficar un nombre igual o superior a 3!\n"); }
    } while (dim % 2 == 0 || dim > DIM_MAX || dim < 3);
    
    do
    {
      generar_quadrat_magic(quadrat_magic, dim);
    } while (!validar_quadrat_magic(quadrat_magic, dim)); /* Aixo serviria si no generes sempre el mateix. */

    printf("\n\n");
    mostrar_matriu(quadrat_magic, dim);

    system("pause > NUL");
    return 0;    
}


int generar_quadrat_magic(int matriu[][C], int dim)
{
    int x, numero_a_ficar = 1, fila_a_ficar = 0, columna_a_ficar = dim / 2;
    int fila_anterior, columna_anterior;

    /* Fica el primer nombre a la columna central de la primera fila: */
    matriu[fila_a_ficar][columna_a_ficar] = numero_a_ficar;

    /* Fica els seguents nombres: */
    for (x = 2; x <= dim*dim; x++)
    {
        /* Guarda la fila i la columna on esta el numero ficat anteriorment: */
        fila_anterior = fila_a_ficar;
        columna_anterior = columna_a_ficar;

        /* Calcula la posicio per a ficar el seguent numero: */
        fila_a_ficar -= 1;
        columna_a_ficar -= 1;

        /* Si la posicio per al seguent numero es menor que 0, torna al costat oposat (com una esfera): */
        if (fila_a_ficar < 0) { fila_a_ficar = dim - 1; }
        if (columna_a_ficar < 0) { columna_a_ficar = dim - 1; }

        /* Si la posicio calculada ja es ocupada, agafa la fila i columna de sota del numero anterior: */
        if (matriu[fila_a_ficar][columna_a_ficar] != 0) { fila_a_ficar = fila_anterior + 1; columna_a_ficar = columna_anterior; }
        
        /* Si la posicio per al seguent numero es menor que 0, torna al costat oposat (com una esfera): */
        if (fila_a_ficar < 0) { fila_a_ficar = dim - 1; }
        if (columna_a_ficar < 0) { columna_a_ficar = dim - 1; }

        /* Fica el numero: */
        matriu[fila_a_ficar][columna_a_ficar] = x;
    }
}


int validar_quadrat_magic(int matriu[][C], int dim)
{
    int f, c, suma_files[F] = { 0 }, suma_columnes[C] = { 0 }, suma_diagonals_principals[2] = { 0 }, tot_be = 1;
    int x = 0, y = dim-1;

    for (f = 0; f < dim; f++)
    {
        suma_diagonals_principals[0] += matriu[f][x++];
        suma_diagonals_principals[1] += matriu[f][y--];
        for (c = 0; c < dim; c++)
        {
            suma_columnes[c] += matriu[f][c];
            suma_files[f] += matriu[f][c];
        }
    }

    /* Comprobar que tot suma el mateix: */
    for (f = 0; f < dim && tot_be; f++)
    {
        /* printf("Fila %d: %d\n", f, suma_files[f]); */
        for (c = 0; c < dim && tot_be; c++)
        {
            /* printf(" Columna %d: %d\n", c, suma_columnes[c]); */
            if (suma_files[f] != suma_columnes[c]) { tot_be = 0; }
        }
    }
    tot_be = (tot_be && suma_diagonals_principals[0] == suma_diagonals_principals[1]);

    /* printf("Diagonal esquerra-dreta/dalt-baix: %d\nDiagonal dreta-esquerra/dalt-baix: %d\n", suma_diagonals_principals[0], suma_diagonals_principals[1]); */
   
    /* Retorna verdader si es un quadrat magic, i fals si no: */
    return tot_be;
}


int mostrar_matriu(int matriu[][C], int dim)
{
    int f, c;
    for (f = 0; f < dim; f++)
    {
        for (c = 0; c < dim; c++)
        {
            printf("%4d", matriu[f][c]);
        }
        printf("\n");
    }
}
